<?php

namespace App\Http\Controllers;

use App\Models\Courier;
use Illuminate\Http\Request;
use App\Models\Settings;

class TrackingController extends Controller
{
    public function form()
    {
        return view('home.track');
    }

    public function search(Request $request)
    {
        $request->validate(['tracking_code' => 'required|string']);

        $courier = Courier::where('tracking_code', $request->tracking_code)->with('updates')->first();
         $settings = Settings::where('id', '=', '1')->first();

        if (!$courier) {
            return redirect()->back()->withErrors(['tracking_code' => 'Tracking code not found.']);
        }

       return view('home.result', compact('courier', 'settings'));

    }
}
