<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>

    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
            <!-- Hero Section -->
<section class="relative h-96 flex items-center justify-center overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-r from-horizon-900/90 to-horizon-700/70 z-10"></div>
    <div class="absolute inset-0">
        <img src="https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
             alt="Track Your Shipment"
             class="w-full h-full object-cover">
    </div>

    <div class="relative z-20 text-center text-white px-4 sm:px-6 lg:px-8">
        <h1 class="font-display text-4xl md:text-6xl font-bold mb-4 animate-slide-up">
            Track Your <span class="text-gold-400">Shipment</span>
        </h1>
        <p class="text-xl mb-4 animate-slide-up" style="animation-delay: 0.2s;">
            Get real-time updates on your package location
        </p>
        <p class="text-lg animate-slide-up" style="animation-delay: 0.4s;">
            Enter your tracking number to see current status and estimated delivery
        </p>
    </div>
</section>

<!-- Tracking Form Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-4xl mx-auto">
            <!-- Tracking Form -->
            <div class="bg-gradient-to-r from-horizon-700 to-horizon-800 rounded-2xl p-8 md:p-12 mb-12 text-white shadow-2xl relative overflow-hidden">
                <div class="absolute right-0 top-0 opacity-10">
                    <i class="fas fa-truck text-9xl transform -rotate-12 translate-x-10 -translate-y-10"></i>
                </div>

                <div class="relative z-10">
                    <h2 class="font-display text-3xl md:text-4xl font-bold mb-4">
                        Track Your Package
                    </h2>
                    <p class="text-lg text-gray-200 mb-8 max-w-2xl">
                        Enter your tracking number below to get real-time updates on your shipment's location, status, and estimated delivery time.
                    </p>
                        <?php $__errorArgs = ['tracking_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                     <div class="mb-6 bg-red-500/20 border border-red-300 text-white px-4 py-3 rounded-lg">
                            <i class="fas fa-exclamation-circle mr-2"></i> <?php echo e($message); ?>

                        </div>
                              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                    <form action="<?php echo e(route('track.search')); ?>" method="POST" class="space-y-6" x-data="{ isLoading: false }" @submit="isLoading = true">
 <?php echo csrf_field(); ?>

                                              <div class="relative">
                            <label for="tracking_number" class="block text-sm font-medium text-gray-200 mb-2">
                                Tracking Number
                            </label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                    <i class="fas fa-search text-gray-400"></i>
                                </div>
                                <input type="text"
                                       id="tracking_number"
                                      name="tracking_code"
                                       placeholder="Enter tracking number (e.g., RMF123456789)"
                                       class="w-full pl-12 pr-4 py-4 bg-white text-gray-700 rounded-lg shadow-inner focus:ring-2 focus:ring-gold-400 focus:border-transparent outline-none transition-all duration-300 hover:shadow-lg"
                                       required>
                                <div class="absolute inset-y-0 right-0 pr-4 flex items-center" x-show="isLoading">
                                    <svg class="animate-spin h-5 w-5 text-gold-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                    </svg>
                                </div>
                            </div>
                            <p class="text-sm text-gray-300 mt-2">
                                <i class="fas fa-info-circle mr-1"></i>
                                You can enter up to tracking numbers
                            </p>
                        </div>

                        <button type="submit"
                                class="w-full md:w-auto px-8 py-4 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-semibold rounded-lg shadow-lg transition-all duration-300 transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500 flex items-center justify-center"
                                :disabled="isLoading">
                            <span x-show="!isLoading">Track Package</span>
                            <span x-show="isLoading">Tracking...</span>
                            <i class="fas fa-arrow-right ml-2" x-show="!isLoading"></i>
                        </button>
                    </form>
                </div>
            </div>

            <!-- Sample Tracking Result (if tracking data exists) -->
                    </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-horizon-50 to-gold-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-4">
                Tracking <span class="text-gold-600">Features</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                Advanced tracking capabilities to keep you informed every step of the way
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Feature 1 -->
            <div class="bg-white rounded-xl shadow-soft p-8 text-center hover:shadow-lg transition-shadow duration-300">
                <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-map-marker-alt text-2xl text-horizon-600"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-4">Live Tracking</h3>
                <p class="text-secondary-600 leading-relaxed">
                    Follow your package in real-time with our interactive map and detailed status updates throughout the delivery process.
                </p>
            </div>

            <!-- Feature 2 -->
            <div class="bg-white rounded-xl shadow-soft p-8 text-center hover:shadow-lg transition-shadow duration-300">
                <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-bell text-2xl text-gold-600"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-4">Delivery Alerts</h3>
                <p class="text-secondary-600 leading-relaxed">
                    Set up SMS or email notifications to stay updated with your package status and receive delivery confirmations.
                </p>
            </div>

            <!-- Feature 3 -->
            <div class="bg-white rounded-xl shadow-soft p-8 text-center hover:shadow-lg transition-shadow duration-300">
                <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-calendar-alt text-2xl text-horizon-600"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-4">Delivery Options</h3>
                <p class="text-secondary-600 leading-relaxed">
                    Customize delivery preferences, reschedule deliveries, or redirect packages to meet your availability.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Support Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-soft p-8 md:p-12">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div>
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-6">
                        Need <span class="text-gold-600">Assistance?</span>
                    </h2>
                    <p class="text-lg text-secondary-600 mb-8 leading-relaxed">
                        Our customer support team is available 24/7 to help with your delivery questions, concerns, and special requests. We're here to ensure your shipping experience is smooth and worry-free.
                    </p>

                    <div class="space-y-4 mb-8">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-gold-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-clock text-gold-600 text-sm"></i>
                            </div>
                            <span class="text-secondary-700">24/7 Customer Support</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-gold-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-headset text-gold-600 text-sm"></i>
                            </div>
                            <span class="text-secondary-700">Expert Logistics Assistance</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-gold-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-shield-alt text-gold-600 text-sm"></i>
                            </div>
                            <span class="text-secondary-700">Secure Package Handling</span>
                        </div>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="mailto:<?php echo e($settings->contact_email); ?>"
                           class="inline-flex items-center justify-center px-6 py-3 bg-horizon-600 hover:bg-horizon-700 text-white font-semibold rounded-lg transition-colors duration-200">
                            <i class="fas fa-envelope mr-2"></i>
                            Email Support
                        </a>
                        <a href="contact"
                           class="inline-flex items-center justify-center px-6 py-3 border-2 border-gold-500 text-gold-600 hover:bg-gold-500 hover:text-white font-semibold rounded-lg transition-colors duration-200">
                            <i class="fas fa-phone mr-2"></i>
                            Contact Us
                        </a>
                    </div>
                </div>

                <div class="flex justify-center">
                    <div class="relative">
                        <img src="https://images.unsplash.com/photo-1553413077-190dd305871c?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=500&amp;q=80"
                             alt="Customer Support"
                             class="w-80 h-80 object-cover rounded-2xl shadow-lg">
                        <div class="absolute -bottom-6 -right-6 w-24 h-24 bg-gold-500 rounded-full flex items-center justify-center shadow-lg">
                            <i class="fas fa-headset text-2xl text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-gold-50 to-horizon-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-4">
                Frequently Asked <span class="text-gold-600">Questions</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                Quick answers to common tracking and delivery questions
            </p>
        </div>

        <div class="max-w-3xl mx-auto space-y-4" x-data="{selected:1}">
            <!-- FAQ 1 -->
            <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                <button
                    @click="selected !== 1 ? selected = 1 : selected = null"
                    class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                >
                    <span>How do I track my package?</span>
                    <svg
                        :class="{'rotate-180': selected === 1}"
                        class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
                <div
                    x-show="selected === 1"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-4"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-150"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-4"
                    class="px-6 py-4 bg-gray-50 text-secondary-700"
                >
                    You can track your package by entering your tracking number in the search field above. Your tracking number is provided in your shipping confirmation email or receipt.
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                <button
                    @click="selected !== 2 ? selected = 2 : selected = null"
                    class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                >
                    <span>What if my package is delayed?</span>
                    <svg
                        :class="{'rotate-180': selected === 2}"
                        class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
                <div
                    x-show="selected === 2"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-4"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-150"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-4"
                    class="px-6 py-4 bg-gray-50 text-secondary-700"
                >
                    If your package is experiencing delays, you'll see updated delivery estimates in your tracking information. For additional assistance, please contact our customer support team.
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                <button
                    @click="selected !== 3 ? selected = 3 : selected = null"
                    class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                >
                    <span>Can I change my delivery address?</span>
                    <svg
                        :class="{'rotate-180': selected === 3}"
                        class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
                <div
                    x-show="selected === 3"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-4"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-150"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-4"
                    class="px-6 py-4 bg-gray-50 text-secondary-700"
                >
                    Yes, in most cases you can change your delivery address by contacting our customer support team with your tracking number and the new delivery details.
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                <button
                    @click="selected !== 4 ? selected = 4 : selected = null"
                    class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                >
                    <span>How accurate are the delivery estimates?</span>
                    <svg
                        :class="{'rotate-180': selected === 4}"
                        class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
                <div
                    x-show="selected === 4"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-4"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-150"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-4"
                    class="px-6 py-4 bg-gray-50 text-secondary-700"
                >
                    Our delivery estimates are highly accurate, based on real-time data and historical delivery patterns. We update estimates automatically if any delays occur during transit.
                </div>
            </div>
        </div>
    </div>
</section>

<script src="https://unpkg.com/alpinejs%403.14.9/dist/cdn.min.js" defer></script>
        </div>
    </main>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/equitywo/app.overseadeliveryservices.com/resources/views/home/track.blade.php ENDPATH**/ ?>