<?php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
?>


<?php $__env->startSection('title', $settings->site_title); ?>


<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>






    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
            <!-- Hero Section -->
<section class="relative h-screen flex items-center justify-center overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-r from-horizon-900/90 to-horizon-700/70 z-10"></div>
    <div class="absolute inset-0">
        <img src="https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
             alt="Comprehensive Services"
             class="w-full h-full object-cover">
    </div>

    <div class="relative z-20 text-center text-white px-4 sm:px-6 lg:px-8">
        <h1 class="font-display text-4xl md:text-6xl lg:text-7xl font-bold mb-6 animate-slide-up">
            Our <span class="text-gold-400">Services</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto animate-slide-up" style="animation-delay: 0.2s;">
            Comprehensive logistics solutions tailored to your business needs
        </p>
        <a href="contact"
           class="inline-flex items-center px-8 py-4 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-semibold rounded-lg transition-all duration-300 transform hover:scale-105 animate-slide-up"
           style="animation-delay: 0.4s;">
            GET STARTED TODAY
            <i class="fas fa-arrow-right ml-2"></i>
        </a>
    </div>
</section>

<!-- Company Overview Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-gold-100 rounded-full mb-6">
                <i class="fas fa-globe text-2xl text-gold-600"></i>
            </div>
            <h2 class="font-display text-3xl md:text-4xl lg:text-5xl font-bold text-horizon-800 mb-6">
                Reliable UK & Ireland Transport<br>
                <span class="text-gold-600">Logistics Since 1973</span>
            </h2>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 mb-16">
            <div class="space-y-6">
                <p class="text-lg text-secondary-600 leading-relaxed">
                    At <?php echo e($settings->site_name); ?>, we believe the supplier-vendor relationship to be an important, strong and long term partnership. Both the client and the logistics partners will concentrate on their lead competencies and work closely together with the common aim to be a leader in each other's sector.
                </p>
                <p class="text-lg text-secondary-600 leading-relaxed">
                    We want to service you in a reliable, efficient and flexible manner, so that your company can compete in its business, not only by selling quality products, but also by satisfying customers with high value logistics services.
                </p>
            </div>

            <div class="space-y-6">
                <p class="text-lg text-secondary-600 leading-relaxed">
                    Since our inception in 1998, we have developed according to our clients' needs from a traditional freight forwarding company to a full service logistics provider. We provide all the necessary services for highly-engineered supply chain solutions.
                </p>
                <p class="text-lg text-secondary-600 leading-relaxed">
                    We combine these with a range of warehousing and freight forwarding services to provide a complete solution tailored to your specific requirements.
                </p>
            </div>
        </div>

        <!-- Service Categories -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-white rounded-lg shadow-soft p-6 text-center hover:shadow-lg transition-shadow duration-300 group">
                <div class="w-16 h-16 bg-gradient-to-r from-horizon-600 to-horizon-700 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-link text-white text-xl"></i>
                </div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-2">
                    Supply Chain<br>Solutions
                </h3>
            </div>

            <div class="bg-white rounded-lg shadow-soft p-6 text-center hover:shadow-lg transition-shadow duration-300 group">
                <div class="w-16 h-16 bg-gradient-to-r from-gold-500 to-gold-600 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-boxes text-white text-xl"></i>
                </div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-2">
                    3PL<br>Services
                </h3>
            </div>

            <div class="bg-white rounded-lg shadow-soft p-6 text-center hover:shadow-lg transition-shadow duration-300 group">
                <div class="w-16 h-16 bg-gradient-to-r from-horizon-600 to-horizon-700 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-shopping-cart text-white text-xl"></i>
                </div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-2">
                    Internet<br>Fulfilment
                </h3>
            </div>

            <div class="bg-white rounded-lg shadow-soft p-6 text-center hover:shadow-lg transition-shadow duration-300 group">
                <div class="w-16 h-16 bg-gradient-to-r from-gold-500 to-gold-600 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-globe-americas text-white text-xl"></i>
                </div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-2">
                    Global Freight<br>Forwarding
                </h3>
            </div>
        </div>
    </div>
</section>

<!-- Supply Chain Solutions Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-horizon-50 to-gold-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-6">
                    Supply Chain <span class="text-gold-600">Solutions</span>
                </h2>
                <p class="text-lg text-secondary-600 leading-relaxed mb-6">
                    At <?php echo e($settings->site_name); ?>, we're passionate about helping our clients operate their supply chains more effectively. To achieve this we design and implement transformative solutions that are customised for every individual client and their unique supply chain challenges.
                </p>
                <p class="text-lg text-secondary-600 leading-relaxed">
                    Using an innovative approach to manage supply chains we've given our clients true supply chain visibility with revolutionary views of their supply chain. We continually work towards achieving operational excellence.
                </p>
            </div>

            <div>
                <img src="https://images.unsplash.com/photo-1553413077-190dd305871c?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Supply Chain Solutions"
                     class="w-full h-96 object-cover rounded-lg shadow-soft">
            </div>
        </div>
    </div>
</section>

<!-- Internet Fulfilment Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div class="order-2 lg:order-1">
                <img src="https://images.unsplash.com/photo-1586528116311-ad8dd3c8310d?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Internet Fulfilment"
                     class="w-full h-96 object-cover rounded-lg shadow-soft">
            </div>

            <div class="order-1 lg:order-2">
                <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-6">
                    Internet <span class="text-gold-600">Fulfilment</span>
                </h2>
                <p class="text-lg text-secondary-600 leading-relaxed mb-6">
                    We pick, pack and dispatch your orders, to save you time and money. We take away the hassle of storing, delivering and handling any product returns and manage your fulfilment so you can concentrate on your key business objectives.
                </p>

                <div class="space-y-4">
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-white text-xs"></i>
                        </div>
                        <span class="text-secondary-700 font-medium">Dedicated secure facilities</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-white text-xs"></i>
                        </div>
                        <span class="text-secondary-700 font-medium">Customs clearances</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-white text-xs"></i>
                        </div>
                        <span class="text-secondary-700 font-medium">Online inventory reporting</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-white text-xs"></i>
                        </div>
                        <span class="text-secondary-700 font-medium">Full order management & back office integration</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Global Freight Forwarding Section -->
<section class="py-16 lg:py-24 bg-gradient-to-r from-horizon-800 to-horizon-900 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="font-display text-3xl md:text-4xl font-bold mb-6">
                    Global Freight <span class="text-gold-400">Forwarding</span>
                </h2>
                <p class="text-lg text-gray-200 leading-relaxed mb-6">
                    At <?php echo e($settings->site_name); ?>, we're passionate about helping our clients operate their supply chains more effectively. To achieve this we design and implement transformative solutions that are customised for every individual client and their unique supply chain challenges.
                </p>
                <p class="text-lg text-gray-200 leading-relaxed">
                    Using an innovative approach to manage supply chains we've given our clients true supply chain visibility with revolutionary views of their supply chain. We continually work towards achieving operational excellence and cost optimization.
                </p>
            </div>

            <div>
                <img src="https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Global Freight Forwarding"
                     class="w-full h-96 object-cover rounded-lg shadow-soft">
            </div>
        </div>
    </div>
</section>

<!-- Our Global World Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-gold-100 rounded-full mb-6">
                <i class="fas fa-world text-2xl text-gold-600"></i>
            </div>
            <h2 class="font-display text-3xl md:text-4xl lg:text-5xl font-bold text-horizon-800 mb-4">
                Our Global <span class="text-gold-600">World</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                Advice and best practice from our own team of logistics experts
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Service 1 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300 text-center">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1494412574643-ff11b0a5c1c3?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="Forwarding Services"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">
                        Forwarding
                    </h3>
                    <p class="text-secondary-600 leading-relaxed">
                        Our dedicated fleet of vehicles operates nationally throughout the UK delivering both full, part, and consolidated loads with precision and care.
                    </p>
                </div>
            </div>

            <!-- Service 2 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300 text-center">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1601584115197-04ecc0da31d7?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="Supply Chain Management"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">
                        Supply Chain
                    </h3>
                    <p class="text-secondary-600 leading-relaxed">
                        Comprehensive supply chain management solutions designed to optimize your operations and reduce costs while maintaining quality.
                    </p>
                </div>
            </div>

            <!-- Service 3 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300 text-center">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="International Logistics"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">
                        International
                    </h3>
                    <p class="text-secondary-600 leading-relaxed">
                        Through our trusted network of partners, we offer comprehensive import and export services across global markets.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Contact CTA Section -->
<section class="py-16 lg:py-24 bg-gradient-to-r from-horizon-700 to-horizon-800 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="font-display text-3xl md:text-4xl lg:text-5xl font-bold mb-6">
            Contact us today!
        </h2>
        <p class="text-xl md:text-2xl mb-8 text-gray-200">
            Contact us today for your logistics and freight <br>
            requirements
        </p>
        <a href="contact"
           class="inline-flex items-center px-8 py-4 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-semibold rounded-lg transition-all duration-300 transform hover:scale-105">
            CLICK HERE TO CONTACT US!
            <i class="fas fa-arrow-right ml-2"></i>
        </a>
    </div>
</section>

<!-- Why Choose Us Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-gold-50 to-horizon-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-4">
                Why Choose <span class="text-gold-600"><?php echo e($settings->site_name); ?>?</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                Discover the advantages of partnering with our experienced logistics team
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="text-center">
                <div class="w-16 h-16 bg-gradient-to-r from-horizon-600 to-horizon-700 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-clock text-white text-xl"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">24/7 Support</h3>
                <p class="text-secondary-600">Round-the-clock customer support to ensure your shipments are always on track.</p>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-gradient-to-r from-gold-500 to-gold-600 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-shield-alt text-white text-xl"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">Secure & Reliable</h3>
                <p class="text-secondary-600">Advanced security measures and reliable tracking systems for complete peace of mind.</p>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-gradient-to-r from-horizon-600 to-horizon-700 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-users text-white text-xl"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">Expert Team</h3>
                <p class="text-secondary-600">Over 120 years of combined experience in logistics and supply chain management.</p>
            </div>
        </div>
    </div>
</section>
        </div>
    </main>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\cargoflow\resources\views/home/services.blade.php ENDPATH**/ ?>